# -*- coding: utf-8 -*-
"""
Created on Wed Apr 21 16:35:32 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_name = 'Selected files'
data_folder_path = os.path.join(main_folder_path,data_folder_name)
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================

selected_files_noALD = ['dyrvik_IGLED19-Batch 21_0040AA_7_0.ilv', \
                 'dyrvik_IGLED19-Batch 20_003ECA_4_0.ilv', \
                 'dyrvik_IGLED19-Batch 20_003ECB_8_1.ilv', \
                 'dyrvik_IGLED19-Batch 20_003ECC_4_0.ilv', \
                 'dyrvik_IGLED19-Batch 20_003ECD_4_0.ilv']

selected_files_10ALD = ['dyrvik_IGLED19-Batch 21_0040A5_4_0.ilv', \
                 'dyrvik_IGLED19-Batch 21_0040A6_4_0.ilv', \
                 'dyrvik_IGLED19-Batch 21_0040A7_7_0.ilv', \
                 'dyrvik_IGLED19-Batch 21_0040A8_4_0.ilv', \
                 'dyrvik_IGLED19-Batch 21_0040A9_6_0.ilv']
    
"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  
    
"""Prepare plots"""
label_strings_noALD = ['No TFB',\
                 '0.5 mg/ml TFB',\
                 '2 mg/ml TFB',\
                 '5 mg/ml TFB',\
                 '10 mg/ml TFB']      

label_strings_10ALD = ['No TFB, 10 c. $\mathregular{Al_2O_3}$',\
                 '0.5 mg/ml TFB, 10 c. $\mathregular{Al_2O_3}$',\
                 '2 mg/ml TFB, 10 c. $\mathregular{Al_2O_3}$',\
                 '5 mg/ml TFB, 10 c. $\mathregular{Al_2O_3}$',\
                 '10 mg/ml TFB, 10 c. $\mathregular{Al_2O_3}$']  
    
colour_array =  np.linspace(0, 999, len(selected_files_noALD))

fig = plt.figure(0)
fig.set_size_inches(15,8)
fig.set_tight_layout(True)
ax = plt.gca()

for i in range(len(selected_files_noALD)):
    """Load data and remove negatives to allow log-plots"""
    file_path = os.path.join(data_folder_path,selected_files_noALD[i])
    df = pd.read_csv(file_path,delimiter='\t')
    
    """Plot the data"""
    df['LED current [mA/cm2]'][df['LED current [mA/cm2]'] < 0] = np.nan
    ax.semilogy(df['LED voltage [V]'], df['LED current [mA/cm2]'], color=COLOURS_GREENS[np.int(colour_array[i])], label=label_strings_noALD[i])
    
for i in range(len(selected_files_10ALD)):
    """Load data and remove negatives to allow log-plots"""
    file_path = os.path.join(data_folder_path,selected_files_10ALD[i])
    df = pd.read_csv(file_path,delimiter='\t')
    
    """Plot the data"""
    df['LED current [mA/cm2]'][df['LED current [mA/cm2]'] < 0] = np.nan
    ax.semilogy(df['LED voltage [V]'], df['LED current [mA/cm2]'], color=COLOURS_ORANGES[np.int(colour_array[i])], label=label_strings_10ALD[i])
    
ax.legend(frameon = False, bbox_to_anchor=(0.98, 0.94), loc = 'upper left')
    
"""Axis settings"""
ax.set_xlabel('Bias [V]')
ax.set_ylabel('Current Density [$\mathregular{mA/cm^2}$]')
ax.set_xlim(left = 0, right = 5)
ax.set_ylim()
ax.xaxis.set_major_locator(mpl.ticker.MultipleLocator(1))
ax.xaxis.set_minor_locator(mpl.ticker.MultipleLocator(0.5))
ax.yaxis.set_major_locator(mpl.ticker.LogLocator(base=10, numticks=12))

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Exporting plots"""
export_name = 'Plot'
plot_name = ' electron-only JV with and without Al2O3'
export_name_pdf = export_name + plot_name + '.pdf'
export_name_svg = export_name + plot_name + '.svg'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path)
fig.savefig(svg_path)
plt.close(fig)
